function out = get_deglac_t(loc)
wgs84 = wgs84Ellipsoid("kilometer");
% get distance along each transect

% east.coast.lat = 78.80;
% east.coast.lon = -69.20;
% east.ice.lat = 78.44;
% east.ice.lon = -68.49;
% east.dist = sqrt((east.coast.lat - east.ice.lat).^2 + (east.coast.lon - east.ice.lon).^2);
% east.m = (east.ice.lat-east.coast.lat)./(east.ice.lon-east.coast.lon);
% east.b = east.coast.lat - (east.m .* east.coast.lon);
% 
% west.coast.lat = 78.58;
% west.coast.lon = -70.74;
% west.ice.lat = 78.29;
% west.ice.lon = -70.12;
% west.dist = distance(west.coast.lat,west.coast.lon,west.ice.lat,west.ice.lon,wgs84); %sqrt((west.coast.lat - west.ice.lat).^2 + (west.coast.lon - west.ice.lon).^2);
% west.m = (west.ice.lat-west.coast.lat)./(west.ice.lon-west.coast.lon);
% west.b = west.coast.lat - (west.m .* west.coast.lon);
% 

east.coast.lat = 78.80;
east.coast.lon = -69.20;
east.ice.lat = 78.44;
east.ice.lon = -68.49;
[east.dist east.az] = distance(east.coast.lat,east.coast.lon,east.ice.lat,east.ice.lon,wgs84);

west.coast.lat = 78.58;
west.coast.lon = -70.74;
west.ice.lat = 78.29;
west.ice.lon = -70.12;
[west.dist west.az] = distance(west.coast.lat,west.coast.lon,west.ice.lat,west.ice.lon,wgs84); 


% get distance of each sample from respective transect 


% if strcmp(loc.transect, 'east') == 1
%     dist_from_trans = abs(loc.lat - east.m.*loc.lon - east.b)./sqrt(1.^2 + (-east.m).^2);
%     dist_from_coast_pt = sqrt((east.coast.lat - loc.lat).^2 + (east.coast.lon - loc.lon).^2);
%     dist_from_coast = sqrt(dist_from_coast_pt.^2 - dist_from_trans.^2);
%     scalar = dist_from_coast./east.dist;
% elseif strcmp(loc.transect, 'west') == 1
%     dist_from_trans = abs(loc.lat - west.m.*loc.lon - west.b)./sqrt(1.^2 + (-west.m).^2);
%     dist_from_coast_pt = sqrt((west.coast.lat - loc.lat).^2 + (west.coast.lon - loc.lon).^2);
%     dist_from_coast = sqrt(dist_from_coast_pt.^2 - dist_from_trans.^2);
%     scalar = dist_from_coast./west.dist;
% else 
%     scalar = 0;
%     display('At least one sample does not belong to a transect')
% end


if strcmp(loc.transect, 'east') == 1
    [dist, az] = distance(east.coast.lat,east.coast.lon,loc.lat,loc.lon,wgs84);
    theta = deg2rad(abs(east.az-az));
    scalar = (cos(theta).*dist)./east.dist;
    
elseif strcmp(loc.transect, 'west') == 1
    [dist, az] = distance(west.coast.lat,west.coast.lon,loc.lat,loc.lon,wgs84);
    theta = deg2rad(abs(west.az-az));
    scalar = (cos(theta).*dist)./west.dist;
else 
    scalar = 0;
    display('At least one sample does not belong to a transect')
end

if scalar < 0
    scalar = 0;
elseif scalar >1
    scalar = 1;
end

deglac_t = 8000 - (scalar .* (8000-6700));

out = deglac_t;

end


